/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.search;

import javax.mail.Address;
import javax.mail.Message;
import javax.mail.search.AddressTerm;

public final class RecipientTerm
extends AddressTerm {
    protected Message.RecipientType type;

    public RecipientTerm(Message.RecipientType recipientType, Address address) {
        super(address);
        this.type = recipientType;
    }

    public Message.RecipientType getRecipientType() {
        return this.type;
    }

    public boolean match(Message message) {
        Address[] addressArray;
        try {
            addressArray = message.getRecipients(this.type);
        }
        catch (Exception exception) {
            return false;
        }
        if (addressArray == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < addressArray.length) {
            if (super.match(addressArray[n2])) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof RecipientTerm)) {
            return false;
        }
        RecipientTerm recipientTerm = (RecipientTerm)object;
        return recipientTerm.type.equals(this.type) && super.equals(object);
    }

    public int hashCode() {
        return this.type.hashCode() + super.hashCode();
    }
}

