/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.Random;
import javax.mail.internet.SharedInputStream;

public class SharedFileInputStream
extends BufferedInputStream
implements SharedInputStream {
    private static int defaultBufferSize = 2048;
    protected byte[] buf;
    protected int count;
    protected int pos;
    protected int markpos = -1;
    protected int marklimit;
    protected RandomAccessFile in;
    protected int bufsize;
    protected long bufpos;
    protected long start;
    protected long datalen;
    private SharedFile sf;

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    public SharedFileInputStream(String string) throws IOException {
        this(string, defaultBufferSize);
    }

    public SharedFileInputStream(String string, int n2) throws IOException {
        super(null);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Buffer size <= 0");
        }
        this.sf = new SharedFile(string);
        this.in = this.sf.open();
        this.start = 0L;
        this.datalen = this.in.length();
        this.bufsize = n2;
        this.buf = new byte[n2];
    }

    private SharedFileInputStream(SharedFile sharedFile, long l2, long l3, int n2) {
        super(null);
        this.sf = sharedFile;
        this.in = sharedFile.open();
        this.start = l2;
        this.bufpos = l2;
        this.datalen = l3;
        this.bufsize = n2;
        this.buf = new byte[n2];
    }

    private void fill() throws IOException {
        int n2;
        int n3;
        if (this.markpos < 0) {
            this.pos = 0;
            this.bufpos += (long)this.count;
        } else if (this.pos >= this.buf.length) {
            if (this.markpos > 0) {
                n3 = this.pos - this.markpos;
                System.arraycopy(this.buf, this.markpos, this.buf, 0, n3);
                this.pos = n3;
                this.bufpos += (long)this.markpos;
                this.markpos = 0;
            } else if (this.buf.length >= this.marklimit) {
                this.markpos = -1;
                this.pos = 0;
                this.bufpos += (long)this.count;
            } else {
                n3 = this.pos * 2;
                if (n3 > this.marklimit) {
                    n3 = this.marklimit;
                }
                byte[] byArray = new byte[n3];
                System.arraycopy(this.buf, 0, byArray, 0, this.pos);
                this.buf = byArray;
            }
        }
        this.count = this.pos;
        this.in.seek(this.bufpos + (long)this.pos);
        n3 = this.buf.length - this.pos;
        if (this.bufpos - this.start + (long)this.pos + (long)n3 > this.datalen) {
            n3 = (int)(this.datalen - (this.bufpos - this.start + (long)this.pos));
        }
        if ((n2 = this.in.read(this.buf, this.pos, n3)) > 0) {
            this.count = n2 + this.pos;
        }
    }

    public synchronized int read() throws IOException {
        this.ensureOpen();
        if (this.pos >= this.count) {
            this.fill();
            if (this.pos >= this.count) {
                return -1;
            }
        }
        return this.buf[this.pos++] & 0xFF;
    }

    private int read1(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.count - this.pos;
        if (n4 <= 0) {
            this.fill();
            n4 = this.count - this.pos;
            if (n4 <= 0) {
                return -1;
            }
        }
        int n5 = n4 < n3 ? n4 : n3;
        System.arraycopy(this.buf, this.pos, byArray, n2, n5);
        this.pos += n5;
        return n5;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int read(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        this.ensureOpen();
        if ((var2_2 | var3_3 | var2_2 + var3_3 | var1_1.length - (var2_2 + var3_3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (var3_3 == 0) {
            return 0;
        }
        var4_4 = this.read1(var1_1, var2_2, var3_3);
        if (var4_4 > 0) ** GOTO lbl11
        return var4_4;
        while ((var5_5 = this.read1(var1_1, var2_2 + var4_4, var3_3 - var4_4)) > 0) {
            var4_4 += var5_5;
lbl11:
            // 2 sources

            if (var4_4 < var3_3) continue;
        }
        return var4_4;
    }

    public synchronized long skip(long l2) throws IOException {
        this.ensureOpen();
        if (l2 <= 0L) {
            return 0L;
        }
        long l3 = this.count - this.pos;
        if (l3 <= 0L) {
            this.fill();
            l3 = this.count - this.pos;
            if (l3 <= 0L) {
                return 0L;
            }
        }
        long l4 = l3 < l2 ? l3 : l2;
        this.pos = (int)((long)this.pos + l4);
        return l4;
    }

    public synchronized int available() throws IOException {
        this.ensureOpen();
        return this.count - this.pos + this.in_available();
    }

    private int in_available() throws IOException {
        return (int)(this.start + this.datalen - (this.bufpos + (long)this.count));
    }

    public synchronized void mark(int n2) {
        this.marklimit = n2;
        this.markpos = this.pos;
    }

    public synchronized void reset() throws IOException {
        this.ensureOpen();
        if (this.markpos < 0) {
            throw new IOException("Resetting to invalid mark");
        }
        this.pos = this.markpos;
    }

    public boolean markSupported() {
        return true;
    }

    public void close() throws IOException {
        if (this.in == null) {
            return;
        }
        try {
            this.sf.close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.sf = null;
            this.in = null;
            this.buf = null;
            throw throwable;
        }
        Object var2_1 = null;
        this.sf = null;
        this.in = null;
        this.buf = null;
    }

    public long getPosition() {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        return this.bufpos + (long)this.pos - this.start;
    }

    public InputStream newStream(long l2, long l3) {
        if (this.in == null) {
            throw new RuntimeException("Stream closed");
        }
        if (l2 < 0L) {
            throw new IllegalArgumentException("start < 0");
        }
        if (l3 == -1L) {
            l3 = this.datalen;
        }
        return new SharedFileInputStream(this.sf, this.start + (long)((int)l2), (int)(l3 - l2), this.bufsize);
    }

    public static void main(String[] stringArray) throws Exception {
        int n2;
        SharedFileInputStream sharedFileInputStream = new SharedFileInputStream(stringArray[0]);
        Random random = new Random();
        while ((n2 = sharedFileInputStream.read()) >= 0) {
            int n3;
            System.out.write(n2);
            if (!(random.nextDouble() < 0.3)) continue;
            InputStream inputStream = sharedFileInputStream.newStream(sharedFileInputStream.getPosition(), -1L);
            while ((n3 = inputStream.read()) >= 0) {
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    class SharedFile {
        private int cnt;
        private RandomAccessFile in;

        SharedFile(String string) throws IOException {
            SharedFileInputStream.this = SharedFileInputStream.this;
            this.in = new RandomAccessFile(string, "r");
        }

        public RandomAccessFile open() {
            ++this.cnt;
            return this.in;
        }

        public synchronized void close() throws IOException {
            if (--this.cnt <= 0) {
                this.in.close();
            }
        }

        protected void finalize() throws Throwable {
            super.finalize();
            this.in.close();
        }
    }
}

