/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BASE64DecoderStream
extends FilterInputStream {
    private byte[] buffer;
    private int bufsize;
    private int index;
    private boolean ignoreErrors = false;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final byte[] pem_convert_array = new byte[256];
    private byte[] decode_buffer = new byte[4];

    public BASE64DecoderStream(InputStream inputStream) {
        super(inputStream);
        this.buffer = new byte[3];
        try {
            String string = System.getProperty("mail.mime.base64.ignoreerrors");
            this.ignoreErrors = string != null && !string.equalsIgnoreCase("false");
            return;
        }
        catch (SecurityException securityException) {
            return;
        }
    }

    public BASE64DecoderStream(InputStream inputStream, boolean bl) {
        super(inputStream);
        this.buffer = new byte[3];
        this.ignoreErrors = bl;
    }

    public int read() throws IOException {
        if (this.index >= this.bufsize) {
            this.decode();
            if (this.bufsize == 0) {
                return -1;
            }
            this.index = 0;
        }
        return this.buffer[this.index++] & 0xFF;
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        while (n4 < n3) {
            int n5 = this.read();
            if (n5 == -1) {
                if (n4 != 0) break;
                n4 = -1;
                break;
            }
            byArray[n2 + n4] = (byte)n5;
            ++n4;
        }
        return n4;
    }

    public boolean markSupported() {
        return false;
    }

    public int available() throws IOException {
        return this.in.available() * 3 / 4 + (this.bufsize - this.index);
    }

    private void decode() throws IOException {
        int n2;
        this.bufsize = 0;
        int n3 = 0;
        while (n3 < 4) {
            n2 = this.in.read();
            if (n2 == -1) {
                if (n3 == 0 || this.ignoreErrors) {
                    return;
                }
                String string = "Error in encoded stream: needed 4 valid base64 characters but only got " + n3 + " before EOF, the valid characters were: \"";
                int n4 = 0;
                while (n4 < n3) {
                    string = String.valueOf(string) + (char)this.decode_buffer[n4];
                    ++n4;
                }
                string = String.valueOf(string) + "\"";
                throw new IOException(string);
            }
            if (n2 < 0 || n2 >= 256 || n2 != 61 && pem_convert_array[n2] == -1) continue;
            this.decode_buffer[n3++] = (byte)n2;
        }
        n2 = pem_convert_array[this.decode_buffer[0] & 0xFF];
        int n5 = pem_convert_array[this.decode_buffer[1] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n2 << 2 & 0xFC | n5 >>> 4 & 3);
        if (this.decode_buffer[2] == 61) {
            return;
        }
        n2 = n5;
        n5 = pem_convert_array[this.decode_buffer[2] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n2 << 4 & 0xF0 | n5 >>> 2 & 0xF);
        if (this.decode_buffer[3] == 61) {
            return;
        }
        n2 = n5;
        n5 = pem_convert_array[this.decode_buffer[3] & 0xFF];
        this.buffer[this.bufsize++] = (byte)(n2 << 6 & 0xC0 | n5 & 0x3F);
    }

    public static byte[] decode(byte[] byArray) {
        int n2 = byArray.length / 4 * 3;
        if (n2 == 0) {
            return byArray;
        }
        if (byArray[byArray.length - 1] == 61) {
            --n2;
            if (byArray[byArray.length - 2] == 61) {
                --n2;
            }
        }
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        int n4 = 0;
        n2 = byArray.length;
        while (n2 > 0) {
            byte by = pem_convert_array[byArray[n3++] & 0xFF];
            byte by2 = pem_convert_array[byArray[n3++] & 0xFF];
            byArray2[n4++] = (byte)(by << 2 & 0xFC | by2 >>> 4 & 3);
            if (byArray[n3] == 61) {
                return byArray2;
            }
            by = by2;
            by2 = pem_convert_array[byArray[n3++] & 0xFF];
            byArray2[n4++] = (byte)(by << 4 & 0xF0 | by2 >>> 2 & 0xF);
            if (byArray[n3] == 61) {
                return byArray2;
            }
            by = by2;
            by2 = pem_convert_array[byArray[n3++] & 0xFF];
            byArray2[n4++] = (byte)(by << 6 & 0xC0 | by2 & 0x3F);
            n2 -= 4;
        }
        return byArray2;
    }

    static {
        int n2 = 0;
        while (n2 < 255) {
            BASE64DecoderStream.pem_convert_array[n2] = -1;
            ++n2;
        }
        int n3 = 0;
        while (n3 < pem_array.length) {
            BASE64DecoderStream.pem_convert_array[BASE64DecoderStream.pem_array[n3]] = (byte)n3;
            ++n3;
        }
    }
}

