/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import javax.mail.Flags;

public class MailboxInfo {
    public Flags availableFlags;
    public Flags permanentFlags;
    public int total = -1;
    public int recent = -1;
    public int first = -1;
    public int uidvalidity = -1;
    public int mode;

    public MailboxInfo(Response[] responseArray) throws ParsingException {
        int n2 = 0;
        while (n2 < responseArray.length) {
            if (responseArray[n2] != null && responseArray[n2] instanceof IMAPResponse) {
                IMAPResponse iMAPResponse = (IMAPResponse)responseArray[n2];
                if (iMAPResponse.keyEquals("EXISTS")) {
                    this.total = iMAPResponse.getNumber();
                    responseArray[n2] = null;
                } else if (iMAPResponse.keyEquals("RECENT")) {
                    this.recent = iMAPResponse.getNumber();
                    responseArray[n2] = null;
                } else if (iMAPResponse.keyEquals("FLAGS")) {
                    this.availableFlags = new FLAGS(iMAPResponse);
                    responseArray[n2] = null;
                } else if (iMAPResponse.isUnTagged() && iMAPResponse.isOK()) {
                    iMAPResponse.skipSpaces();
                    if (iMAPResponse.readByte() != 91) {
                        iMAPResponse.reset();
                    } else {
                        boolean bl = true;
                        String string = iMAPResponse.readAtom();
                        if (string.equalsIgnoreCase("UNSEEN")) {
                            this.first = iMAPResponse.readNumber();
                        } else if (string.equalsIgnoreCase("UIDVALIDITY")) {
                            this.uidvalidity = iMAPResponse.readNumber();
                        } else if (string.equalsIgnoreCase("PERMANENTFLAGS")) {
                            this.permanentFlags = new FLAGS(iMAPResponse);
                        } else if (!string.equalsIgnoreCase("UIDNEXT")) {
                            bl = false;
                        }
                        if (bl) {
                            responseArray[n2] = null;
                        } else {
                            iMAPResponse.reset();
                        }
                    }
                }
            }
            ++n2;
        }
        if (this.permanentFlags == null) {
            if (this.availableFlags != null) {
                this.permanentFlags = new Flags(this.availableFlags);
                return;
            }
            this.permanentFlags = new Flags();
        }
    }
}

