/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import javax.activation.DataHandler;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.search.SearchTerm;

public abstract class Message
implements Part {
    protected int msgnum;
    protected boolean expunged = false;
    protected Folder folder;
    protected Session session;

    protected Message() {
    }

    protected Message(Folder folder, int n2) {
        this.folder = folder;
        this.msgnum = n2;
        this.session = folder.store.session;
    }

    protected Message(Session session) {
        this.session = session;
    }

    public abstract Address[] getFrom() throws MessagingException;

    public abstract void setFrom() throws MessagingException;

    public abstract void setFrom(Address var1) throws MessagingException;

    public abstract void addFrom(Address[] var1) throws MessagingException;

    public abstract Address[] getRecipients(RecipientType var1) throws MessagingException;

    public Address[] getAllRecipients() throws MessagingException {
        Address[] addressArray = this.getRecipients(RecipientType.TO);
        Address[] addressArray2 = this.getRecipients(RecipientType.CC);
        Address[] addressArray3 = this.getRecipients(RecipientType.BCC);
        if (addressArray2 == null && addressArray3 == null) {
            return addressArray;
        }
        int n2 = (addressArray != null ? addressArray.length : 0) + (addressArray2 != null ? addressArray2.length : 0) + (addressArray3 != null ? addressArray3.length : 0);
        Address[] addressArray4 = new Address[n2];
        int n3 = 0;
        if (addressArray != null) {
            System.arraycopy(addressArray, 0, addressArray4, n3, addressArray.length);
            n3 += addressArray.length;
        }
        if (addressArray2 != null) {
            System.arraycopy(addressArray2, 0, addressArray4, n3, addressArray2.length);
            n3 += addressArray2.length;
        }
        if (addressArray3 != null) {
            System.arraycopy(addressArray3, 0, addressArray4, n3, addressArray3.length);
            n3 += addressArray3.length;
        }
        return addressArray4;
    }

    public abstract void setRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void setRecipient(RecipientType recipientType, Address address) throws MessagingException {
        Address[] addressArray = new Address[]{address};
        this.setRecipients(recipientType, addressArray);
    }

    public abstract void addRecipients(RecipientType var1, Address[] var2) throws MessagingException;

    public void addRecipient(RecipientType recipientType, Address address) throws MessagingException {
        Address[] addressArray = new Address[]{address};
        this.addRecipients(recipientType, addressArray);
    }

    public Address[] getReplyTo() throws MessagingException {
        return this.getFrom();
    }

    public void setReplyTo(Address[] addressArray) throws MessagingException {
        throw new MethodNotSupportedException("setReplyTo not supported");
    }

    public abstract String getSubject() throws MessagingException;

    public abstract void setSubject(String var1) throws MessagingException;

    public abstract Date getSentDate() throws MessagingException;

    public abstract void setSentDate(Date var1) throws MessagingException;

    public abstract Date getReceivedDate() throws MessagingException;

    public abstract Flags getFlags() throws MessagingException;

    public boolean isSet(Flags.Flag flag) throws MessagingException {
        return this.getFlags().contains(flag);
    }

    public abstract void setFlags(Flags var1, boolean var2) throws MessagingException;

    public void setFlag(Flags.Flag flag, boolean bl) throws MessagingException {
        Flags flags = new Flags(flag);
        this.setFlags(flags, bl);
    }

    public int getMessageNumber() {
        return this.msgnum;
    }

    protected void setMessageNumber(int n2) {
        this.msgnum = n2;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public boolean isExpunged() {
        return this.expunged;
    }

    protected void setExpunged(boolean bl) {
        this.expunged = bl;
    }

    public abstract Message reply(boolean var1) throws MessagingException;

    public abstract void saveChanges() throws MessagingException;

    public boolean match(SearchTerm searchTerm) throws MessagingException {
        return searchTerm.match(this);
    }

    public abstract int getSize() throws MessagingException;

    public abstract int getLineCount() throws MessagingException;

    public abstract String getContentType() throws MessagingException;

    public abstract boolean isMimeType(String var1) throws MessagingException;

    public abstract String getDisposition() throws MessagingException;

    public abstract void setDisposition(String var1) throws MessagingException;

    public abstract String getDescription() throws MessagingException;

    public abstract void setDescription(String var1) throws MessagingException;

    public abstract String getFileName() throws MessagingException;

    public abstract void setFileName(String var1) throws MessagingException;

    public abstract InputStream getInputStream() throws IOException, MessagingException;

    public abstract DataHandler getDataHandler() throws MessagingException;

    public abstract Object getContent() throws IOException, MessagingException;

    public abstract void setDataHandler(DataHandler var1) throws MessagingException;

    public abstract void setContent(Object var1, String var2) throws MessagingException;

    public abstract void setText(String var1) throws MessagingException;

    public abstract void setContent(Multipart var1) throws MessagingException;

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;

    public abstract String[] getHeader(String var1) throws MessagingException;

    public abstract void setHeader(String var1, String var2) throws MessagingException;

    public abstract void addHeader(String var1, String var2) throws MessagingException;

    public abstract void removeHeader(String var1) throws MessagingException;

    public abstract Enumeration getAllHeaders() throws MessagingException;

    public abstract Enumeration getMatchingHeaders(String[] var1) throws MessagingException;

    public abstract Enumeration getNonMatchingHeaders(String[] var1) throws MessagingException;

    public static class RecipientType
    implements Serializable {
        public static final RecipientType TO = new RecipientType("To");
        public static final RecipientType CC = new RecipientType("Cc");
        public static final RecipientType BCC = new RecipientType("Bcc");
        protected String type;

        protected RecipientType(String string) {
            this.type = string;
        }

        protected Object readResolve() throws ObjectStreamException {
            if (this.type.equals("To")) {
                return TO;
            }
            if (this.type.equals("Cc")) {
                return CC;
            }
            if (this.type.equals("Bcc")) {
                return BCC;
            }
            throw new InvalidObjectException("Attempt to resolve unknown RecipientType: " + this.type);
        }

        public String toString() {
            return this.type;
        }
    }
}

